/*
	File: CEG_actions.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to execute code from an action menu command, specifically, to manually turn power off and on at a substation transformer circuit bus.

	Parameters:
	_this select 3: object passed from the addAction command array.
 
	Execution:
	Executed from an action menu command attached to a CEG object (addAction added in CEG_common.sqf).  Will only run locally on the machine that activated it.
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_actions.sqf: Thread Started for:", (_this select 3)] call LGD_fnc_debugMessage;}; //DEBUG
 
// Scope //
private ["_obj", "_outStr", "_out", "_logicStr", "_logic", "_odds", "_result1", "_result2"];
 
// Parameter(s) //
_obj = (_this select 3);

// Get the value of the "power out" status of this object and store it in a local variable.
_outStr = format ["CEG_out_%1", _obj];
_out = missionNameSpace getVariable _outStr;

// Determine the game logic located near this object.
_logicStr = (format ["CEG_logic_%1", _obj]);
_logic = missionNameSpace getVariable _logicStr;

//Get the current state of the "power out" switch of the object.  If true (on) then set to false, if false (off) set to true.
if ((_out)) then
{
	missionNameSpace setVariable [_outStr, false];
}
else
{
	missionNameSpace setVariable [_outStr, true];
}; 

// Public variable the change to all other machines (if they exist) for possible action in a thread of CEG_monitor.sqf running for this object..		
publicVariable _outStr;

// Make the game logic at the object's location emit the appropriate sound of a circuit breaker opening (tripping) or closing.

if ((_out)) then
{
	_logic say ["CEG_Open", 5];
}
else
{
	_logic say ["CEG_Close", 5];
}; 

// Determine whether manipulating the breaker will cause an arc flash explosion.  Determined by the missionmaker by declaring a value to CEC_arc.  Default (nil) is zero chance of arc flash.
if (isNil "CEG_explode") then {} else
{
	if (!(_logic getVariable "operational")) exitWith {};
	
	_odds = round (CEG_explode);
	_result1 = ceil (random _odds);
	_result2 = ceil (random _odds);
	
	if (_result1 == _result2) then
	{
		// If the machine is SP or a MP Host (servers)  or a MP client (Multiplayer) then directly execute the script to cause an explosion and pertinent effects since a PVEH will not fire on those machines.  
		if ((isServer) or (isMultiplayer)) then
		{
			_nul = [_logic] execVM "CEG\Scripts\CEG_flash.sqf";
		};
		
		// If this is a multiplayer game then broadcast that an explosion should occur to all other machines by triggering a PVEH.
		if (isMultiplayer) then
		{
			CEG_arc = _logic;
			publicVariable "CEG_arc";
		};
	};
};

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_actions.sqf: Thread finished for:", (_this select 3)] call LGD_fnc_debugMessage;}; //DEBUG